# 帳票設計書 34-カスタムルート一覧（Custom Routes）

## 概要

本ドキュメントは、Next.jsビルド完了時にコンソールに出力されるカスタムルート一覧（リダイレクト・リライト・ヘッダー）の設計仕様を定義する。

### 本帳票の処理概要

本帳票は、`next build` 完了時に標準出力（コンソール）に表示されるカスタムルート（Redirects / Rewrites / Headers）の一覧である。`next.config.js` で定義されたリダイレクト、リライト、カスタムヘッダーの設定を可視化し、開発者がルーティング設定を確認できるようにする。

**業務上の目的・背景**：Next.jsでは `next.config.js` の `redirects`、`rewrites`、`headers` 関数でカスタムルーティングルールを定義できる。ビルド完了時にこれらの設定を一覧表示することで、設定ミスの早期発見やルーティング構成の確認を支援する。

**帳票の利用シーン**：(1) ビルド完了後のカスタムルート設定確認、(2) リダイレクト・リライト設定のデバッグ、(3) カスタムヘッダー設定の確認。

**主要な出力内容**：
1. Redirects: ソース、デスティネーション、ステータスコード/permanentフラグ
2. Headers: ソース、ヘッダーキー・値のペア
3. Rewrites: ソース、デスティネーション（beforeFiles, afterFiles, fallbackを統合）

**帳票の出力タイミング**：`next build` コマンド完了直前。カスタムルートが定義されている場合のみ表示される。

**帳票の利用者**：フロントエンドエンジニア、DevOpsエンジニア。

## 帳票種別

コンソール出力（標準出力へのテキスト表示）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next build` | ビルド完了時に自動出力（カスタムルート存在時のみ） |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（コンソール出力、ANSIカラーコード付き） |
| 用紙サイズ | N/A（コンソール出力） |
| 向き | N/A |
| ファイル名 | N/A（ファイル出力なし、標準出力のみ） |
| 出力方法 | console.log経由の標準出力 |
| 文字コード | UTF-8 |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

各カスタムルートの種別（Redirects/Headers/Rewrites）ごとにセクション分けして表示する。

```
Redirects
┌ source: /old-page
├ destination: /new-page
└ permanent: true

┌ source: /legacy/:path*
├ destination: /modern/:path*
└ status: 308

Headers
┌ source: /api/:path*
└ headers:
  ├ X-Custom-Header: value1
  └ X-Another-Header: value2

Rewrites
┌ source: /external-api/:path*
└ destination: https://api.example.com/:path*
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ルート種別 | Redirects / Headers / Rewrites | 種別固定文字列 | 下線付きテキスト |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | source | マッチパターン | route.source | `┌ source: {value}` | 可変 |
| 2 | destination | 転送先（Redirects/Rewrites） | route.destination | `├/└ destination: {value}` | 可変 |
| 3 | permanent/status | リダイレクトの永続性（Redirects） | route.permanent / route.statusCode | `└ permanent: {value}` / `└ status: {value}` | 可変 |
| 4 | headers | ヘッダー一覧（Headers） | route.headers | `└ headers:` + `├/└ {key}: {value}` | 可変 |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Redirects | redirects配列が空でない場合のみ表示 | No |
| Headers | headers配列が空でない場合のみ表示 | No |
| Rewrites | beforeFiles + afterFiles + fallbackが空でない場合のみ表示 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 種別順 | Redirects → Headers → Rewrites の固定順 |
| 2 | 定義順 | 各種別内は定義順を維持 |

### 改ページ条件

N/A

## データベース参照仕様

N/A（next.config.jsの設定情報を直接参照）

### 参照テーブル一覧

N/A

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| combinedRewrites | [...beforeFiles, ...afterFiles, ...fallback] | N/A | 3種類のリライトを統合 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next build 完了] --> B[printCustomRoutes 呼び出し]
    B --> C{Redirects 存在?}
    C -->|Yes| D[Redirects 表示]
    C -->|No| E{Headers 存在?}
    D --> E
    E -->|Yes| F[Headers 表示]
    E -->|No| G{Rewrites 存在?}
    F --> G
    G -->|Yes| H[combinedRewrites 作成]
    H --> I[Rewrites 表示]
    G -->|No| J[終了]
    I --> J
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | すべてのカスタムルートが空の場合 | 何も表示しない | 正常動作 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | 即時（文字列整形のみ） |
| 同時出力数上限 | 1（ビルド完了時に1回のみ） |

## セキュリティ考慮事項

コンソール出力のみであり、ファイルには記録されない。リダイレクト先URLやカスタムヘッダー値が表示されるため、CI/CDログの公開範囲に注意が必要。特にカスタムヘッダーに認証トークン等を含む場合は注意。

## 備考

- Rewritesは3種類（beforeFiles, afterFiles, fallback）が統合されて表示される
- RedirectsではstatusCodeが設定されている場合はstatusを、そうでない場合はpermanentフラグを表示する
- ヘッダーの最終項目は`└`、それ以外は`├`で表示される
- `print`変数は`console.log`のエイリアスとして定義されている（行136）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カスタムルートのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | load-custom-routes.ts | `packages/next/src/lib/load-custom-routes.ts` | Redirect, Rewrite, Header, CustomRoutes型の定義 |

**読解のコツ**: CustomRoutes型はredirects, rewrites, headersの3つのプロパティを持つ。rewritesはbeforeFiles, afterFiles, fallbackの3つのサブ配列を持つ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | utils.ts | `packages/next/src/build/utils.ts` | printCustomRoutes関数（行645-717） |

**主要処理フロー**:
1. **行645-649**: 関数シグネチャ。CustomRoutesオブジェクトを受け取る
2. **行650-698**: 内部関数printRoutesで各種別のルート一覧を整形
3. **行702-704**: redirectsが存在する場合に表示
4. **行705-707**: headersが存在する場合に表示
5. **行709-716**: rewritesの3種類を統合して表示

#### Step 3: 個別ルート整形を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | utils.ts | `packages/next/src/build/utils.ts` | printRoutes内部関数（行650-698）のルート文字列生成ロジック |

**主要処理フロー**:
- **行665**: sourceを`┌`で表示
- **行667-671**: Redirects/Rewritesのdestinationを表示（Redirectsは`├`、Rewritesは`└`）
- **行673-679**: Redirectsのstatus/permanent表示
- **行682-692**: Headersのキー・値ペアをツリー表示

### プログラム呼び出し階層図

```
next build (packages/next/src/build/index.ts)
    │
    └─ printCustomRoutes() (packages/next/src/build/utils.ts 行645)
           └─ printRoutes() (内部関数 行650)
                  ├─ Redirects ルート整形・表示
                  ├─ Headers ルート整形・表示
                  └─ Rewrites ルート整形・表示
```

### データフロー図

```
[入力]                          [処理]                              [出力]

next.config.js                   loadCustomRoutes()
  redirects ──────────────────▶     │
  rewrites  ──────────────────▶     ├─ printRoutes("Redirects")  ──▶ コンソール出力
  headers   ──────────────────▶     ├─ printRoutes("Headers")    ──▶   (stdout)
                                    └─ printRoutes("Rewrites")   ──▶
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| utils.ts | `packages/next/src/build/utils.ts` | ソース | printCustomRoutes関数の実装 |
| index.ts | `packages/next/src/build/index.ts` | ソース | printCustomRoutesの呼び出し元 |
| load-custom-routes.ts | `packages/next/src/lib/load-custom-routes.ts` | ソース | CustomRoutes型、Redirect/Rewrite/Header型の定義 |
